//*********************************************************************
// file			: MQ6801_TBT.c
// version		: V1.1 2021/02/24
// brief		: TBT related functions
// note			: TBT related functions are gathered in this subroutine
//*********************************************************************

#include "main.h"

//*********************************************************************
// name			: TBT_Init
// brief		: TBT initialization
// note			:
//*********************************************************************
void TBT_Init(void)
{
	
//====== parameter setting ======
    TBTCR_TBTCK   = 1;                  // select the TBT interrupt frequency
										// fcgck =4MHz, TBT interrupt frequency = 3.81469Hz
                                        //                                 (fcgck / 2^20 = 3.81469Hz)
										// TBT interrupt period = 1/3.81469 = 0.26214 Sec

										
    NOP;                                // no operation
}


//*********************************************************************
// name			: TBT_Start
// brief		: start TBT
// note			:
//*********************************************************************
void TBT_Start(void)
{
    TBTCR_TBTEN   = 1;
}


//*********************************************************************
// name			: TBT_Stop
// brief		: stop TBT
// note			:
//*********************************************************************
void TBT_Stop(void)
{
    TBTCR_TBTEN   = 0;
}


//*********************************************************************
// name			: TBT_IntEnable
// brief		: enable TBT interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TBT_IntEnable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    IL_INTTBT  = 0;                     // clear interrupt latch
    EI_INTTBT  = 1;                     // set interrupt enable flag
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}

//*********************************************************************
// name			: TBT_IntDisable
// brief		: disable TBT interrupt
// note			: after execution, Interrupt Master Allowed Flag (IMF) will be enabled
//*********************************************************************
void TBT_IntDisable(void)
{
    DI;                                 // disable all maskable interrupts // EIRL_IMF=0
    EI_INTTBT  = 0;                     // clear interrupt enable flag
    IL_INTTBT  = 0;                     // clear interrupt latch
    EI;                                 // enable all maskable interrupts // EIRL_IMF=1
}


//*********************************************************************
// name			: IntTBT
// brief		: TBT interrupt service routine
// note			:
//*********************************************************************
void __interrupt IntTBT(void)
{
    P9DR_P0 =!P9DR_P0;					// reverse P90 output level	
    NOP;                                // no operation
}

